from models import User

import csv
import numpy as np

def generate_users(correctness_mean, correctness_std, confidence_mean,confidence_std, n):
    # Generate correctness values from normal distribution and clip to [0,1]
    correctness_values = np.random.normal(correctness_mean, correctness_std, n)
    # correctness_values = [iq_to_percentage(x) for x in correctness_values]
    
    # Generate confidence values from normal distribution and clip to [0,1]
    confidence_values = np.random.normal(confidence_mean, confidence_std, n)
    # confidence_values = [iq_to_percentage(x) for x in confidence_values]
    users = [User]*n
    for i in range(n):
        user = User(
                id=i+1,
                correctness=correctness_values[i],
                confidence=confidence_values[i]
            )
        users[i] = user
    return users

def write_users(filename, users):
    # Write to CSV
    with open(filename, 'w+', newline='') as csvfile:
        writer = csv.writer(csvfile)
        # Write header
        writer.writerow(['id', 'correctness', 'confidence'])
        for user in users:
            writer.writerow([user.id, user.correctness, user.confidence])