class User:
    def __init__(self, id, correctness, confidence):
        self.id = id
        self.correctness = float(correctness)
        self.confidence = float(confidence)
    
    def __repr__(self):
        return f"User(id={self.id}, correctness={self.correctness:.4f}, confidence={self.confidence:.4f})"
    
class Statement:
    def __init__(self, id, text, truth):
        self.id = id
        self.text = text
        self.truth = int(truth)  # Assuming truth is a binary 0/1 value
    
    def __repr__(self):
        return f"Statement(id={self.id}, text='{self.text}', truth={self.truth})"
    
class Response:
    def __init__(self, id, user_id, statement_id, text, truth, confidence):
        self.id=id
        self.user_id=user_id
        self.statement_id=statement_id
        self.text=text
        self.truth = truth
        self.confidence = confidence

    def __repr__(self):
        return f"Response(id={self.id}, user_id={self.user_id}, statement_id={self.statement_id}, text={self.text}, truth={self.truth}, confidence='{self.confidence}')"
    
class Reputation:
    def __init__(self, id, value):
        self.id = id
        self.value = value

    def __repr__(self):
        return f"Reputation(id={self.id}, value={self.value}')"