import numpy as np
import skfuzzy as fuzz

def fuzzy_response(user_input):
    uncertain_words = ["maybe", "probably", "not sure", "possibly"]
    score = sum(word in user_input.lower() for word in uncertain_words)

    x = np.arange(0, 11, 1)
    fuzziness = fuzz.trimf(x, [0, 5, 10])

    fuzzy_value = fuzz.interp_membership(x, fuzziness, score)

    if fuzzy_value > 0.7:
        return "High Uncertainty detected."
    elif fuzzy_value > 0.3:
        return "Moderate Uncertainty detected."
    else:
        return "Low Uncertainty."
