from pyswip import Prolog

def logic_response(user_input):
    prolog = Prolog()
    
    # Define the 'likes' predicate
    prolog.assertz("likes(john, pizza)")
    prolog.assertz("likes(mary, sushi)")
    
    # Define the 'human' predicate based on 'likes'
    prolog.assertz("human(X) :- likes(X, pizza)")
    
    # If the user_input mentions 'pizza', assert that 'user' likes pizza
    if "pizza" in user_input.lower():
        prolog.assertz("likes(user, pizza)")
    
    # Query whether 'user' is human
    result = list(prolog.query("human(user)"))
    
    if result:
        return "Logical Inference: You are human."
    else:
        return "Logical Inference: Cannot determine if human."
