from flask import Flask, request, render_template
import os
from groq import Groq
from fuzzy_logic import fuzzy_response
from logic_reasoning import logic_response
from dotenv import load_dotenv
app = Flask(__name__)

load_dotenv()
# Initialize Groq client
client = Groq(api_key=os.getenv("GROQ_API_KEY"))

def basic_groq_response(prompt):
    chat_completion = client.chat.completions.create(
        messages=[
            {"role": "system", "content": "You are a helpful assistant."},
            {"role": "user", "content": prompt}
        ],
        model="llama3-8b-8192"  # Replace with your desired model
    )
    return chat_completion.choices[0].message.content

@app.route("/", methods=["GET", "POST"])
def index():
    response = ""
    if request.method == "POST":
        user_input = request.form["user_input"]

        # Get responses
        groq_reply = basic_groq_response(user_input)
        fuzzy_reply = fuzzy_response(user_input)
        logic_reply = logic_response(user_input)

        # Combine responses
        response = f"Groq: {groq_reply}\nFuzzy Logic: {fuzzy_reply}\nProlog Logic: {logic_reply}"

    return render_template("index.html", response=response)

if __name__ == "__main__":
    app.run(debug=True)
