from models import Statement

import csv
import random
import string

def generate_random_string(length=3):
    return ''.join(random.choices(string.ascii_uppercase, k=length))

def generate_statement():
    first_part = generate_random_string()
    second_part = generate_random_string()
    return f"<{first_part} --> {second_part}>"

def generate_statements(n):
    statements = [Statement]*n
    for i in range(n):
        statement = Statement(
            id = i+1,
            text = generate_statement(),
            truth = random.randint(0,1),
        )
        statements[i] = statement
    return statements

def write_statements(filename, statements):
    with open(filename, 'w+', newline='') as csvfile:
        writer = csv.writer(csvfile)
        writer.writerow(['id', 'text', 'truth'])
        for statement in statements:
            writer.writerow([statement.id, statement.text, statement.truth])

def write_test(filename, statements):
    with open(filename, 'w+') as file:
        for statement in statements:
            file.write(f'{statement.text}?\n')