from models import Response

# rate at which we update a users reputation
LEARNING_RATE = 0.01


# takes a confidence and a weight 
# returns a new confidence based on the weight
def apply(confidence, weight):
    new_confidence = confidence + weight
    # Ensure result stays within bounds
    return round(max(0.0001, min(0.9999, new_confidence)), 4)

# takes a user id, the users response and the consensus response
# updates the users reputation in the system
def update(reputation, user_id, user_response, consensus):
    # if there is no consensus, we can't say anything about the users reputation
    if (consensus == 0):
        return reputation
    
    # User agrees with consensus
    if (consensus > 0 and user_response == 0.9999) or (consensus < 0 and user_response == 0.0001):
        reputation[user_id] = round(reputation[user_id] + LEARNING_RATE,4)
        if (user_id == 51):
            print(f'troll user agrees with consensus {reputation[user_id]}')
    else:
        reputation[user_id] = round(reputation[user_id] - LEARNING_RATE,4)
        if (user_id == 51):
            print(f'troll user disagrees with consensus {reputation[user_id]}')


    return reputation

# this is not an efficient way to evaluate the data, but we do it this way to 
# mimick an online algorithm. We do not assume that we will have users data
# all at once, but that we will continuously evaluate users reputation over 
# time.

# this function is doing two things
# 1. updating users response confidence based on their reputation
# 2. after each round of questions, updating the users reputation

def reputation_responses(control_responses, users, statements):
    idx = {}
    data = {}
    reputation = {}
    # populate map of users to their reputations
    # reputation weights start at 0
    for user in users:
        idx[user.id] = 1
        data[user.id] = [len(statements)+1]
        data[user.id][0] = 0
        reputation[user.id] = 0
    

    # map of statement ids to consensus truth values
    consensus = {}

    # create a map of statement ids => consensus truth value
    for response in control_responses:
        if response.statement_id not in consensus:
            consensus[response.statement_id] = 0
        if response.truth == 0.9999:
            consensus[response.statement_id] += 1
        else:
            consensus[response.statement_id] -= 1

    rr = []
    for response in control_responses:
        w = reputation[response.user_id]
        r = Response(
            id = response.id,
            user_id=response.user_id,
            statement_id=response.statement_id,
            text=response.text,
            truth=response.truth,
            confidence=apply(response.confidence,w),
        )

        reputation = update(reputation, response.user_id, response.truth, consensus[response.statement_id])
        i = idx[response.user_id]
        data[user.id][i] = w
        idx[response.user_id] += 1
        rr.append(r)

    with open('reputation_data.txt', 'w+') as file:
        for key in data:
            file.write(f'{key}: ')
            for ele in data[key]:
                file.write(f'{ele}, ')
            file.write('\n')

    return rr
