from models import Statement 

import csv
import re

def read_statements_from_csv(filename):
    statements = {}
    
    with open(filename, 'r') as file:
        csv_reader = csv.DictReader(file)
        for row in csv_reader:
            statements[row['text']] = float(row['truth'])
    
    return statements


def read_statements_from_nal(filename):
    statements = {}

    with open(filename, 'r') as file:
        content = file.read()
        pattern = r'Answer\s+(<.+?>)\.\s+%([0-9.]+);[0-9.]+%'
            
        # Find all matches in the content
        matches = re.findall(pattern, content)
        
        # Create a dictionary of statements to truth values
        statements = {statement: float(truth) for statement, truth in matches}

    return statements
    
            
        

if __name__ == "__main__":

    # creats a 5x4 matrix of zeros
    results = [[0 for _ in range(4)] for _ in range(5)]
    for i in range(5):
        statements = read_statements_from_csv(f'./data/{i}/statements.csv')
        cs = read_statements_from_nal(f'./results/{i}/control.nal')
        rs = read_statements_from_nal(f'./results/{i}/reputation.nal')

        tcs = read_statements_from_nal(f'./results/{i}/troll_control.nal')
        trs = read_statements_from_nal(f'./results/{i}/troll_reputation.nal')
        for text in statements:
            results[i][0] += abs(statements[text] - cs[text])
            results[i][1] += abs(statements[text] - rs[text])
            results[i][2] += abs(statements[text] - tcs[text])
            results[i][3] += abs(statements[text] - trs[text])
        print(f'{round(results[i][0],4)} {round(results[i][1],4)} {round(results[i][2],4)} {round(results[i][3],4)}')

    avg = [0 for _ in range(4)]
    for i in range(5):
        for j in range(4):
            avg[j] += results[i][j]
    avg = [round(x/5,4) for x in avg]

    print(f'avg\t control: {avg[0]}\nreputation: {avg[1]}\ntroll control: {avg[2]}\ntroll reputation: {avg[3]}')


