from users import generate_users, write_users
from statements import generate_statements, write_statements, write_test
from responses import write_responses
from control import control_responses
from reputation import reputation_responses
from models import Response, User

import os

CORRECTNESS_MEAN=100
CORRECTNESS_STD=15
CONFIDENCE_MEAN=100
CONFIDENCE_STD=15


if __name__ == "__main__":
    for i in range(5):
        directory_name = f'./data/{i}'
        try:
            os.mkdir(directory_name)
            print(f"Directory '{directory_name}' created successfully.")
        except FileExistsError:
            print(f"Directory '{directory_name}' already exists.")
        except PermissionError:
            print(f"Permission denied: Unable to create '{directory_name}'.")
        except Exception as e:
            print(f"An error occurred: {e}")

        statements = generate_statements(50)
        write_statements(f'{directory_name}/statements.csv',statements)
        write_test(f'{directory_name}/test.nal', statements)

        users = generate_users(CORRECTNESS_MEAN, CORRECTNESS_STD, CONFIDENCE_MEAN,CONFIDENCE_STD, 50)
        # users.append(User(tid, 0, 145))

        write_users(f'{directory_name}/users.csv', users)

        cr = control_responses(users, statements)
        write_responses(f'{directory_name}/control.nal', cr)

        rr = reputation_responses(cr, users)
        write_responses(f'{directory_name}/reputation.nal', rr)

        # add troll
        tid = len(users) + 1
        users.append(User(tid, 0, 145))
        for statement in statements:
            r = Response(
                id = len(cr) + 1,
                user_id=tid,
                statement_id=statement.id,
                text=statement.text,
                truth = 0.0001 if (statement.truth) else 0.9999,
                confidence = 0.9999,
            )
            cr.append(r)

        write_responses(f'{directory_name}/troll_control.nal', cr)
        tr = reputation_responses(cr, users)
        write_responses(f'{directory_name}/troll_reputation.nal', tr)

