from models import Response

import random

def iq_to_percentage(iq, iq_min=55, iq_max=145):
    iq_clamped = max(iq_min, min(iq, iq_max))  # clamp to bounds
    return (iq_clamped - iq_min) / (iq_max - iq_min)

# takes a user and a statement
# returns the correct answer a percentage of the time based on the users correctness score
def correctness(user, statement):
    r = random.randint(0, 145)
    
    if r < user.correctness:
        if (statement.truth):
            return 0.9999
        else:
            return 0.0001
    else:
        if (statement.truth):
            return 0.0001
        else:
            return 0.9999
    

# takes a user
# returns a confidence based on the users score
def confidence(user):
    return round(iq_to_percentage(user.confidence),4)


def control_responses(users, statements):
    responses = [Response]*len(users)*len(statements)
    i=0
    for statement in statements:
        for user in users:
            f = correctness(user, statement)
            c = confidence(user)
            response = Response(
                id = i,
                user_id=user.id,
                statement_id=statement.id,
                text=statement.text,
                truth = f,
                confidence = c,
            )
            responses[i]=response
            i += 1
    return responses
