"""
Task
"""
from ..Base.Item import Item
from .Composition import CompositionMirror
from ..Base.Buffer import Buffer
from Narsese import Budget
from Narsese import Truth
from .Location import Location
from typing import Generic, TypeVar


class Task(Item):
    proto = None

    def __init__(self, center: tuple[float, float], mirrors: list[CompositionMirror], truth_event: Truth = None, truth_anticpation: Truth=None, budget_c: Budget = None) -> None:
        Item.__init__(self, None, budget_c)
        # self.mirrors = {m.item: m for m in mirrors}
        self.mirrors = Buffer[CompositionMirror](len(mirrors))
        for mirror in mirrors:
            self.mirrors.insert(mirror)

        self.truth_event = Truth(0.0, 0.0) if truth_event is None else truth_event
        self.truth_anticipation = Truth(0.0, 0.0) if truth_anticpation is None else truth_anticpation
        self.location = Location(center)

    def decay(self, ts_now: float, duration=20):
        self.budget_c.decay(ts_now - self.budget_c.ts_update)
        self.budget_c.ts_update = ts_now

        self.truth_event.decay(
            Truth.get_decay_factor(duration),
            ts_now - self.truth_event.ts_update)
        self.truth_event.ts_update = ts_now

        self.truth_anticipation.decay(
            Truth.get_decay_factor(duration),
            ts_now - self.truth_event.ts_update)
        self.truth_anticipation.ts_update = ts_now

        for mirror in self.mirrors.buff:
            mirror.decay(ts_now, duration)
    
    def __repr__(self) -> str:
        return f"<Task({str(hex(id(self)))[-4:]}): {self.budget_c} [({self.location.center[0]:.2f},{self.location.center[1]:0.2f})]>"
