from Narsese import Budget
from typing import Generic, TypeVar


class Item:
    def __init__(self, budget_m: Budget=None, budget_c: Budget=None) -> None:
        self.budget_m = budget_m if budget_m is not None else Budget()
        self.budget_c = budget_c if budget_c is not None else Budget()

    def __repr__(self) -> str:
        return f"<Item: {self.budget_m}>"
    
ItemVar = TypeVar('ItemVar', bound=Item)

class Mirror(Item, Generic[ItemVar]):
    def __init__(self, item: ItemVar, budget_m: Budget=None, budget_c: Budget=None) -> None:
        Item.__init__(self, budget_m, budget_c)
        self.item = item

    def decay(self, ts_now: float, duration=20):
        self.budget_m.decay(ts_now - self.budget_m.ts_update)
        self.budget_m.ts_update = ts_now
        self.budget_c.decay(ts_now - self.budget_c.ts_update)
        self.budget_c.ts_update = ts_now