'''
Generalized Bell function
'''

import numpy as np
import matplotlib.pyplot as plt
from utils import gbellmf

# Example usage:
x_values = np.linspace(-20, 20, 2001)  # Generate input values

a = 4  # Width parameter
r = 2
b = 3  # Shape parameter
c = 0.0  # Center parameter

plt.title('Generalized Bell Function')
plt.xlabel('Input')
plt.ylabel('Output')
plt.axvline(x=c, color='r', linestyle='--', label='Center')
plt.grid(True)
for r in np.linspace(0.1, 1.0, 5):
    b = r*a*2  # Shape parameter

    # Compute the output of the generalized Bell function
    y_values = gbellmf(x_values, a, b, c)

    # Plot the function
    plt.plot(x_values, y_values)
plt.axvline(x=c+a, color='r', linestyle='--', label='Center')
plt.axvline(x=c-a, color='r', linestyle='--', label='Center')
plt.show()


