'''
Generalized Bell function
'''

import numpy as np
import matplotlib.pyplot as plt
from utils import gbellmf

# Example usage:
x_values = np.linspace(-20, 20, 2001)  # Generate input values

a = 4  # Width parameter
r = 2
b = 3  # Shape parameter
c = 0.0  # Center parameter

plt.figure(figsize=(5,3))
plt.subplots_adjust(bottom=0.15)
plt.title(f"Generalized Bell Function (a={a:.2f}, c={c:.2f})")
plt.xlabel('Δs')
plt.ylabel('spatial projection')
plt.axvline(x=c, color='r', linestyle='--', alpha=0.25)
plt.grid(True)
# for r in np.linspace(0.1, 1.0, 4):
for r in [0.1, 0.2, 0.5, 1.0]:
    b = r*a*2  # Shape parameter

    # Compute the output of the generalized Bell function
    y_values = gbellmf(x_values, a, b, c)

    # Plot the function
    plt.plot(x_values, y_values, label=f"b/2a={b/a/2:.2f}")
plt.axvline(x=c+a, color='r', linestyle='--', alpha=0.25)
plt.axvline(x=c-a, color='r', linestyle='--', alpha=0.25)
plt.legend()
plt.show()


