from .Concept import Concept
from .Feature import Feature
from .Location import Location
from Narsese import Budget

class FLPair(Concept):
    """
    Feature-Location Pair
    """

    def __init__(self, feat: Feature, loc: Location, budget_m: Budget=None, budget_c: Budget=None) -> None:
        """
        Args:
            feat: feature
            loc: location
        """
        Concept().__init__(budget_m, budget_c)

        self.feature = feat
        self.location = loc


    def activate(self):
        pass # TODO
    
    def __iter__(self):
        return iter((self.feature, self.location))