#define VERSION "0.1"

/*
  This code has been released under the GNU Public License.  If you are
  unfamiliar with this license, you must read the LICENSE file that came
  with this package and you must adhere to the requirements within it.
*/

/*
  DNS BLocker
  Dave's Naughty Stuff Blocker

  This program is designed to spoof DNS requests matching strings or
  sites configured by the user.  The intention is to poison the DNS cache
  within your own site with the address of an internal web server that
  can be used to log inappropriate requests.  You will need to configure
  your web server to respond to any and all requests with an "Access Denied"
  page of some kind.


  TODO:
  
  Add Signal support to make for easier reloading of configuration files.
  Add coherent comments to this code (especially the construction of
  the spoofed reply)
  Track down a troublesome segmentation fault that only seems to occur
  sporadically when listening on more than on interface.
  Modify logging to include date/time and interface.
*/

#include<netinet/in.h>
#include<netinet/in_systm.h>
#include<netinet/ip.h>
#include<netinet/udp.h>
#include<stdlib.h>
#include<stdio.h>
#include<libnet.h>
#include<pcap.h>
#include<string.h>

void usage(char *prog_name);
char bad_dests[65000];
char bad_strings[65000][20];
char orig_query_string[512];
char allowed_sites[1000][40];
int num_patterns, num_sites;
char redirect_to[4];
FILE *Requests_fp;
FILE *blocked_fp;
int requests_pending;
int blocked_pending;

int blocked_dest(char *request, uint32_t source);
void spoof_reply(uint32_t source, uint16_t source_port,
		 uint32_t dest, uint16_t dest_port,
		 uint32_t request_id, int q_type, char qhigh, char qlow);
void read_config();

char *
intoa(u_int32_t addr)
{
  char *cp;
  u_int byte;
  int n;
  static char buf[sizeof(".xxx.xxx.xxx.xxx")];
  sprintf(buf, "%d.%d.%d.%d", (u_char)(addr>>24),
	  (u_char)(addr >> 16),
	  (u_char)(addr >> 8),
	  (u_char)(addr));
  //        ntohl(addr);
  return buf;
}


void process_packet(const register u_char *bp, struct pcap_pkthdr *h, const register u_char *bp2)
{
  const register struct ip *ip;
  const register struct udphdr *up;
  const register unsigned char *DNSRecord;
  register u_int16_t sport, dport;
  register uint32_t source, dest;
  char src[20], dst[20];
  int x,y;
  unsigned long id;
  char query;
  char query_string[1024], q_type_string[256];
  char *ptr, *ptr2, *hold;
  char num_chars;
  int q_type;
  char pointer, addr, ns, mx, qlow, qhigh;
  char src_string[20], dst_string[20];
  pointer = addr = ns = mx = 0;
  
  ip = (struct ip *)(bp2+14);
  up = (struct udphdr *)(bp2+14+((bp2[14] & 15) * 4));
  id = (*((unsigned char *)up + 8) << 8) + (*((unsigned char *)up + 9));
  query = ((((unsigned char *)up)[10] & 0x80) == 0 ? 1 : 0 );
  qhigh =  ((unsigned char *)up)[10];
  qlow =  ((unsigned char *)up)[11];
  sport = ntohs(up->uh_sport);
  dport = ntohs(up->uh_dport);
  source = ntohl(ip->ip_src.s_addr);
  dest = ntohl(ip->ip_dst.s_addr);
  
  //  if((dest > 0xaa810000 && dest < 0xaa813200) ||
  //   (dest > 0xaa8132ff && dest < 0xaa81ffff)) {
  if(1) 
    { // Process any request.
      DNSRecord = (unsigned char *)up + 8;
      ptr = (char *)DNSRecord + 12;
      hold = ptr;
      ptr2 = query_string - 1;
      num_chars = *ptr;
      while(num_chars != 0) 
	{
	  ptr++;
	  ptr2++;
	  strncpy(ptr2,ptr,num_chars);
	  ptr2 += num_chars;
	  *ptr2 = '.';
	  ptr += num_chars;
	  num_chars = *ptr;
	}
      *ptr2 = 0;
      ptr ++;
      strncpy(orig_query_string, hold, (ptr - hold));
      q_type = *((uint16_t *)ptr);
      q_type = htons(q_type);
      if(q_type == 0x000c) { pointer = 1; strcpy(q_type_string, "PTR"); }
      if(q_type == 0x0001) { addr = 1; strcpy(q_type_string, "ADDR"); }
      if(q_type == 0x0002) { ns = 1; strcpy(q_type_string, "NS"); }
      if(q_type == 0x000f) { mx = 1; strcpy(q_type_string, "MX"); }
      
      /*
	for(x=0,y=0;x!=32;x++, y++)
	{
	printf("%2x ",(unsigned char)bp2[x+14]);
	if(y==7)
	{ 
	y = -1;
	printf("\n");
	}
	}
      */
      if(query)
	{
	  /*      printf("%x sends %s(%x) request %s %u to %x\n",source, q_type_string,
		  q_type, query_string, id, dest);
	  */
	  strcpy(dst_string, intoa(dest));
	  strcpy(src_string, intoa(source));
	  
	  /*      fprintf(Requests_fp, "%s requests (%s) %s (%d) from %s\n", src_string,
		  q_type_string, query_string, id, dst_string); */
	  
	  // Only log ADDR requests.
	  if(blocked_dest(query_string,source)) 
	    {
	      spoof_reply(source, sport, dest, dport, id, q_type, qhigh, qlow);
	    }
	  else 
	    {
	      fprintf(Requests_fp, "%s : %s\n", intoa(source), query_string);
	      fflush(Requests_fp);
	    }
	}
    }
}

int main(int argc, char **argv)
{
  char device[10];
  FILE *fp;
  int snaplen = 1514;
  int promisc = 1;
  int to_ms = 0;
  int i;
  char ebuff[512];
  pcap_t *stethoscope;
  u_char buffer[2048];
  struct bpf_program udp_program;

  printf("DNS Blocker - Version %s\n", VERSION);
  if(argc > 1)
    {
      if(argc != 3)
	{
	  usage(argv[0]);
	  exit(1);
	}
      if(strcmp(argv[1],"-i") != 0)
	{
	  usage(argv[0]);
	  exit(1);
	}
      if(strlen(argv[2]) > 9 || strlen(argv[2]) < 1)
	{
	  usage(argv[0]);
	  exit(1);
	}
      strcpy(device,argv[2]);
    }
  else
    {
      strcpy(device, pcap_lookupdev(ebuff));
    }
  read_config();
  Requests_fp = fopen("/var/log/dns_requests", "a");
  if(!Requests_fp) 
    {
      printf("Error opening /var/log/dns_requests for writing.\n");
      exit(1);
    }
  blocked_fp = fopen("/var/log/blocked", "a");
  if(!blocked_fp) 
    {
      printf("Error opening /var/log/blocked for writing.\n");
    }
  blocked_pending = 0;
  requests_pending = 0;
  stethoscope = pcap_open_live(device, snaplen, promisc, to_ms, ebuff);
  if(!stethoscope) 
    {
      printf("Error opening %s for listening!\n", device);
      exit(0);
    }
  printf("Active on %s\n",device);
  // We only care about UDP based lookups to port 53
  pcap_compile(stethoscope, &udp_program, "udp and port 53", 1, 0);
  pcap_setfilter(stethoscope, &udp_program);
  pcap_loop(stethoscope, -1, (pcap_handler)process_packet, buffer);
}


void spoof_reply(uint32_t source, uint16_t source_port,
		 uint32_t dest, uint16_t dest_port,
		 uint32_t request_id, int q_type, char qhigh, char qlow)
{
  u_char *packet;
  int network, packet_size;
  // Modified to a 512 payload just in case of a 250 byte request.
  u_char payload[512];
  int location;
  packet_size = LIBNET_IP_H + LIBNET_UDP_H + 512;
  

  libnet_init_packet(packet_size, &packet);
  network = libnet_open_raw_sock(IPPROTO_RAW);

  ((uint16_t *)payload)[0] = htons(request_id);
  payload[2] = qhigh | 0x80;
  payload[3] = qlow | 0x40;
  //  ((uint16_t *)payload)[1]= htons(0x8180); // Now why the heck did I comment this out?
  // Authoritative & recursed
  // Recursion Available, no error
  ((uint16_t *)payload)[2] = htons(0x0001);
  ((uint16_t *)payload)[3] = htons(0x0001);
  ((uint16_t *)payload)[4] = htons(0x0000);
  ((uint16_t *)payload)[5] = htons(0x0000);
  if(q_type == 0x0001) 
    {
      strcpy((char *)payload + 12, orig_query_string);
      location = strlen(orig_query_string);
      location = location + 12;
      // TODO: This all used to be set into blocks with comments, but got pulled
      // apart during debugging...  It needs to be put back together.

      payload[location++] = 0x00;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0xc0;
      payload[location++] = 0x0c;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x00;
      payload[location++] = 0x09;
      payload[location++] = 0x25;
      payload[location++] = 0x00;
      payload[location++] = 0x04;
      payload[location++] = redirect_to[0];
      payload[location++] = redirect_to[1];
      payload[location++] = redirect_to[2];
      payload[location++] = redirect_to[3];
      payload[location++] = 0x04;
      payload[location++] = 0x73;
      payload[location++] = 0x6d;
      payload[location++] = 0x73;
      payload[location++] = 0x63;
      payload[location++] = 0x03;
      payload[location++] = 0x63;
      payload[location++] = 0x6f;
      payload[location++] = 0x6d;
      payload[location++] = 0x00;
      payload[location++] = 0x00;
      payload[location++] = 0x02;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x50;
      payload[location++] = 0x04;
      payload[location++] = 0x00;
      payload[location++] = 0x0b;
      payload[location++] = 0x08;
      payload[location++] = 0x6d;
      payload[location++] = 0x69;
      payload[location++] = 0x64;
      payload[location++] = 0x67;
      payload[location++] = 0x61;
      payload[location++] = 0x61;
      payload[location++] = 0x72;
      payload[location++] = 0x64;
      payload[location++] = 0xc0;
      payload[location++] = 0x2f;
      payload[location++] = 0xc0;
      payload[location++] = 0x43;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x50;
      payload[location++] = 0x04;
      payload[location++] = 0x00;
      payload[location++] = 0x04;
      payload[location++] = 0xaa;
      payload[location++] = 0x81;
      payload[location++] = 0x35;
      payload[location++] = 0x34;
    } 
  else
    {
      strcpy((char *)payload + 12, orig_query_string);
      location = strlen(orig_query_string);
      location = location + 12;
      payload[location++] = 0x00;
      payload[location++] = 0x00;
      payload[location++] = 0x0c;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0xc0;
      payload[location++] = 0x0c;
      payload[location++] = 0x00;
      payload[location++] = 0x0c;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x00;
      payload[location++] = 0x01;
      payload[location++] = 0x51;
      payload[location++] = 0x56;
      payload[location++] = 0x00;
      payload[location++] = 0x0f;
      payload[location++] = 0x04;
      payload[location++] = 0x64;
      payload[location++] = 0x6e;
      payload[location++] = 0x73;
      payload[location++] = 0x32;
      payload[location++] = 0x00;
    }
  packet_size = LIBNET_IP_H + LIBNET_UDP_H + location;
  libnet_build_ip(packet_size,  // Changed from LIBNET_UDP_H
		  0,
		  random()%30000,
		  0,
		  64,
		  IPPROTO_UDP,
		  htonl(dest),
		  htonl(source),
		  payload,
		  location,
		  packet);
  
  libnet_build_udp(dest_port,
		   source_port,
		   payload,
		   location,
		   packet + LIBNET_IP_H);
  
  libnet_write_ip(network, packet, packet_size);
  libnet_close_raw_sock(network);
  libnet_destroy_packet(&packet);
}

int blocked_dest(char *request, uint32_t source)
{
  int x,y;
  char lower_request[280];

  x = strlen(request);
  if(x < 4 || x > 250)
    {
      fprintf(blocked_fp,"%s : Bad Request- %s\n",intoa(source), request);
      fflush(blocked_fp);
      return 0;
    }
  lower_request[x] = 0;
  for(;x>0;x--) { lower_request[x-1] = tolower(request[x-1]); }
  // The next line checks for explicitly permitted sites.
  for(x=0;x!=num_sites;x++){ if(strcmp(lower_request, allowed_sites[x])==0) return 0; }
  if(strstr(bad_dests, lower_request)) 
    {
      fprintf(blocked_fp,"%s : Matched full name- %s\n",intoa(source), lower_request);
      blocked_pending ++;
      if(blocked_pending > 10) { blocked_pending = 0; fflush(blocked_fp); }
      return 1;
    }
  
  for(x=0; x != num_patterns; x++) 
    {
      if(strstr(lower_request, bad_strings[x])) 
	{
	  fprintf(blocked_fp, "%s : Matched substring %s- %s\n",intoa(source),
		  bad_strings[x],
		  lower_request);
	  fflush(blocked_fp);
	  return 1;
	}
    }
  return 0;
}

void read_config()
{

  FILE *fp;
  char buff[256], *ptr;
  int i;

  fp = fopen("/etc/block_web_addr","r");
  if(!fp) 
    {
      printf("Could not open /etc/block_web_addr\n");
      exit(1);
    }
  fgets(buff, 254, fp);
  fclose(fp);
  ptr = buff;
  for(i=0; i < 4; i++) 
    {
      redirect_to[i] = (char)atoi(ptr);
      ptr = strchr(ptr, '.');
      if(!ptr && i < 3) 
	{
	  printf("Invalid redirect IP address: %s\n",buff);
	  exit(1);
	}
      ptr ++;
    }
  fp = fopen("/etc/blocked_names","r");
  if(!fp) 
    { 
      printf("Could not open /etc/blocked_names\n");
      exit(1);
    }
  fread(bad_dests, 1, 64999, fp);
  fclose(fp);
  
  fp = fopen("/etc/blocked_strings","r");
  if(!fp) 
    { 
      printf("Could not open /etc/blocked_strings\n");
      exit(1);
    }
  for(i = 0; i < 65000 && !feof(fp); i++) 
    {
      fgets(bad_strings[i], 20, fp);
      bad_strings[i][strlen(bad_strings[i])-1] = 0;
      if(bad_strings[i][0] == 0){ i --; }
    }
  printf("Read in %d strings.\n",i);
  num_patterns = i;
  fclose(fp);
  
  fp = fopen("/etc/allowed_sites","r");
  if(!fp) 
    { 
      printf("Could not open /etc/allowed_sites\n");
      exit(1);
    }
  for(i = 0; i < 1000 && !feof(fp); i++) 
    {
      fgets(allowed_sites[i], 40, fp);
      allowed_sites[i][strlen(allowed_sites[i])-1] = 0;
      if(allowed_sites[i][0] == 0){ i --; }
    }
  printf("Read in %d explicitly permitted sites.\n",i);
  num_sites = i;
  fclose(fp);
}

void usage(char *prog_name)
{
  printf("Usage:  %s [-i interface]\n", prog_name);
}
