/*     
 * $RCSfile: xk_semaphore.c,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 */

/*
 * Counting semaphores implemented on top of threads package.
 */

#include <sys/types.h>
#include "xk_semaphore.h"
#include "xk_thread.h"


void
semInit(Semaphore* s, u_int initialVal)
{
    s->count = initialVal;
    queueInit(&s->waitingQ);
}


void
semWait(Semaphore* s)
{
    if (--s->count < 0) {
	queueAppend(&s->waitingQ, tSelf);
	threadSuspend();
    }
}


void
semSignal(Semaphore* s)
{
    Thread t;

    if (s->count++ < 0) {
	t = queueRemove(&s->waitingQ);
	threadWakeup(t);
    }
}


int
semCount (Semaphore* s)
{
    return s->count;
}


extern void
semSignalAll (Semaphore* s)
{
    int i, nblocked = -s->count;

    for (i = 0; i < nblocked; ++i) {
	semSignal(s);
    }
}
