/*     
 * $RCSfile: inputProcess.h,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Revision: 1.2 $
 * $Date: 1996/01/31 16:23:54 $
 */

/* 
 * External interface for input buffer pools
 */

#include "msg.h"
#include "upi.h"

typedef struct inputBuffer InputBuffer;

typedef void	(* BlockDemuxFunc )( InputBuffer * );

struct inputBuffer {
    /* 
     * Public
     */
    Msg 	msg;  /* the data ptr is the msg stack */
    Semaphore 	sem;
    char *	data;
    Sessn 	self;
    /* 
     * Private
     */
    u_int 	id;
    u_char	ref;
    int		maxBufSize;
    BlockDemuxFunc	demux;
};

/* top-level pool of buffers */
typedef struct {
    int 		total_blocks;
    int 		next_block;
    InputBuffer *	blocks;
} BufferPool;



BufferPool	*xkBufferPoolInit( int poolSz, int dataSz, BlockDemuxFunc );
InputBuffer	*xkBufferPoolNextBlock( BufferPool * );
void		xkBufferPoolDump( BufferPool * );
void		xkBufferPoolReleaseBlock( InputBuffer * );
