/*
 * @COPYRIGHT@
 * 
 * x-kernel v3.3
 * 
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 * 
 * @COPYRIGHT@
 *
 * $RCSfile: xendian.h,v $
 *
 * HISTORY
 * $Log: xendian.h,v $
 * Revision 1.1  1996/01/31  15:49:07  slm
 * Initial revision
 *
 */
#ifndef xendian_h
#define xendian_h

/*
 * Definitions for byte order, according to byte significance from low
 * address to high.
 */
#define LITTLE	1234	/* least-significant byte first (vax) */
#define BIG	4321	/* most-significant byte first */
#define PDP	3412	/* LSB first in word, MSW first in long (pdp) */

#include "xendian_arch.h"

#if (ENDIAN == BIG)
# define ntohs(s) (s)
# define htons(s) (s)
# define ntohl(s) (s)
# define htonl(s) (s)
#else
  extern u_short ntohs (u_short net_short);
  extern u_short htons (u_short host_short);
  extern u_int	 ntohl (u_int net_int);
  extern u_int	 htonl (u_int host_int);
#endif /* ENDIAN == BIG */

#endif /* xendian_h */
