/* 
 * process.h
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 */

#ifndef process_h
#define process_h

#include "/usr/include/pthread.h"
#include <stdarg.h>

#define XKTHREAD_SELF() pthread_self()
#define XKTHREAD_TYPE   pthread_t

#include "xtype.h"

#define STD_PRIO       0
#define THREAD_MAXPRIO 20
#define THREAD_MINPRIO (-20)

#ifndef NULL
#define NULL 0
#endif

#if 0	/*  not for linux, either */
#if (defined(USE_GC) && !defined(sparc))        /* not for sparc */
#define malloc(X) gc_malloc(X)
#define free(X) gc_free(X)
#endif
#endif

typedef void (*CreateProcFunc) ( int, ... );

#define CreateProcess0 CreateProcess
#define CreateProcess1 CreateProcess
#define CreateProcess2 CreateProcess
#define CreateProcess3 CreateProcess
#define CreateProcess4 CreateProcess
#define CreateProcess5 CreateProcess
#define CreateProcess6 CreateProcess
#define xCreateProcess CreateProcess

typedef struct _Process {
   XKTHREAD_TYPE	thread;
} Process;

#define STACKSIZE (32*1024)

typedef struct _Semaphore
{
  pthread_mutex_t mutex;
  pthread_cond_t  cond;
  volatile int    count;
} Semaphore;

extern Process *Active;
extern int      SignalsPossible;

#define kSwitch() Yield()

/* The -DXKLOCKDEBUG switch provides for counting the locking depth, and
   complaining if it isn't 1.  It has a bug, in that the increment & decrement
   instructions aren't atomic in RISC architectures.  Presumably, the occasions
   where this fails are rare.  */

#ifdef XKLOCKDEBUG
extern int xklockdepthreq;
extern int xklockdepth;
extern int tracexklock;
#endif

/* the master concurrency locks */
extern pthread_mutex_t master_lock;

#ifndef XKLOCKDEBUG

#define MASTER_LOCK pthread_mutex_lock(&master_lock)
#define MASTER_UNLOCK pthread_mutex_unlock(&master_lock)

#else	/* XKLOCKDEBUG */

#define MASTER_LOCK                                                           \
do {xklockdepthreq++;                                                         \
 xTrace1(xklock,TR_EVENTS,"requesting xklock, depthreq %d",xklockdepthreq);   \
 pthread_mutex_lock(&master_lock);                       \
 xklockdepth++;                                                               \
 if (xklockdepth!=1)                                                          \
 { xTrace1(xklock,TR_ERRORS,"got xklock, wrong depth %d",xklockdepth); };     \
 xTrace2(xklock,TR_EVENTS,"got xklock, depth %d, depthreq %d",                \
         xklockdepth,xklockdepthreq); } while(0)
#define MASTER_UNLOCK                                                         \
do {if (xklockdepth!=1)                                                       \
 {xTrace1(xklock,TR_ERRORS,"giving up xklock, wrong depth %d",xklockdepth); };\
 xTrace2(xklock,TR_EVENTS,"giving up xklock, depth %d, depthreq %d",          \
         xklockdepth,xklockdepthreq);                                         \
 xklockdepth--;                                                               \
 pthread_mutex_unlock(&master_lock);                     \
 xTrace1(xklock,TR_EVENTS,"gave up xklock, depthreq %d",xklockdepthreq);      \
 xklockdepthreq--; } while(0)

#endif XKLOCKDEBUG

#ifdef __STDC__


void    xk_master_lock( void );
void    xk_master_unlock( void );
void semWait(Semaphore *s);
void semSignal(Semaphore *s);
void semInit(Semaphore *s,unsigned n);
void Yield(void);

bool CreateProcess(void *, int, int, ... );
void threadInit( void );

#else

void    xk_master_lock( );
void    xk_master_unlock( );
void semWait( );
void semSignal( );
void semInit( );
void Yield( );

bool CreateProcess( );
void threadInit( );

#endif
#endif 
