/*
 * trace.c
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Revision: 1.2 $
 * $Date: 1996/01/31 16:25:17 $
 */

#include "platform.h"
#include "xk_debug.h"
#include "compose.h"
#include "xk_semaphore.h"

#ifdef XK_TRACE_LOCKING
static Semaphore lock;
#endif

void
xTraceLock(void)
{
#ifdef XK_TRACE_LOCKING
    semWait( &lock );
#endif
}

void
xTraceUnlock(void)
{
#ifdef XK_TRACE_LOCKING
    semSignal( &lock );
#endif
}

 

void
xTraceInit(void)
{
#ifdef XK_TRACE_LOCKING
    semInit(&lock , 1 );
    initTraceLevels();
#endif
}

