/*
 */
#ifndef __queue_h__
#define __queue_h__

/*
 * This module provides a general queueing service if producers and
 * consumers operate synchronously (i.e., under control of
 * scout_thread.c).
 */

typedef struct Queue *		Queue;
typedef struct QueueEl *	QueueEl;

struct QueueEl {
    QueueEl	next;
};

struct Queue {
    QueueEl	head;
    QueueEl	tail;
};

extern void	queueInit (Queue q);
extern void	queueAppend (Queue q, void * element);
extern void	queueInsert (Queue q, void * after, void * element);
extern void *	queueRemove (Queue q);
extern void	queueDelete (Queue q, void * after);
extern QueueEl	queueHead (Queue q);
extern QueueEl	queueTail (Queue q);

#define queueHead( q ) ((q)->head)
#define queueTail( q ) ((q)->tail)

#endif /* __queue_h__ */
