/*     
 * $RCSfile: x_libc.h,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Log: x_libc.h,v $
 * Revision 1.2  1996/01/31  16:23:54  slm
 * Updated copyright and version.
 *
 * Revision 1.1  1995/07/29  02:56:13  slm
 * Initial revision
 *
 * Revision 1.2.1.1.1.1  1994/10/28  17:33:17  hkaram
 * New branch
 *
 * Revision 1.2.1.1  1994/06/10  17:37:35  menze
 * Use <stdlib.h>
 */

/*
 * C library prototypes
 */

#ifndef x_libc_h
#define x_libc_h

#include <string.h>
#include <stdlib.h>

#ifdef __STDC__

#ifdef XKBSD
extern void     bcopy( char *, char *, int );
extern int	bcmp( char *, char *, int );
extern void     bzero( char *, int );
#else
#define bcopy(src, dst, count) memmove (dst, src, count )
#define bcmp(src, dst, count) memcmp (dst, src, count )
#define bzero(dst, count) memset (dst, 0, count )
#endif
typedef 	int (* QSortFunc)(const void *, const void *);

#else

#ifdef XKBSD
extern void     bcopy();
extern int	bcmp();
extern void     bzero();
#else
#define bcopy(src, dst, count) memmove (dst, src, count )
#define bcmp(src, dst, count) memcmp (dst, src, count )
#define bzero(dst, count) memset( dst, 0, count )
#endif

#endif  __STDC__

#endif  ! x_libc_h
