/* 
 * $RCSfile: xk_assert.h,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Log: xk_assert.h,v $
 * Revision 1.1  1996/01/31  15:49:07  slm
 * Initial revision
 *
 * Revision 1.13.1.1  1994/04/01  16:54:49  menze
 * changed name of assertMsg macro ... was causing conflicts
 *
 * Revision 1.13  1994/02/05  00:10:49  menze
 *   [ 1994/01/28          menze ]
 *   Renamed to xk_assert.h to avoid name conflicts
 */

#ifndef xk_assert_h
#define xk_assert_h

#if ! defined(FILE) && ! defined(XKMACHKERNEL)
#include "x_stdio.h"
#endif

#ifndef XKMACHKERNEL
#  ifdef __STDC__
extern void abort(void);
#  else
extern void abort();
#  endif __STDC__
#  define ABORT abort
#  define PRINT(A,B,C) fprintf(stderr, (A), (B), (C))
#else
#  define PRINT(A,B,C) printf((A), (B), (C))
extern int panic();
#  define ABORT() panic("xkernel assertion")
#endif /* XKMACHKERNEL */

#define assertMsg "Assertion failed: file %s, line %d\n"

#ifdef XK_DEBUG
#   define _xAssert(ex) { if ( ! (ex) ) PRINT(assertMsg, __FILE__, __LINE__), ABORT(); }
#   define xAssert(ex) { if ( ! (ex) ) PRINT(assertMsg, __FILE__, __LINE__), ABORT(); }
#else
#   define _xAssert(ex) {}
#   define xAssert(ex) {}
#endif /* XK_DEBUG */

#endif /* ! xk_assert_h */
