#ifndef __thread_h__
#define __thread_h__

typedef enum {
    THREAD_PRIO_MAX = 0,
    THREAD_PRIO_STD = 1,
    THREAD_PRIO_MIN = 2
} ThreadPrio;

typedef void			(*ThreadFunc)(void* arg);

typedef struct ThreadStack *	ThreadStack;

typedef struct Thread *		Thread;
typedef struct ThreadOptions *	ThreadOptions;

struct ThreadOptions {
    char *		name;		/* thread name */
    void*  		arg;		/* argument to be passed to FUN */
    ThreadPrio		priority;	/* thread priority */
};

struct Thread {
    Thread			next;		/* linked list of threads */
    int      			errno;		/* per-thread errno */
    long			running   : 1;	/* has thread been started? */
    ThreadStack			stack;
    ThreadFunc			func;
    struct ThreadOptions	option;
    long			magic;
};

extern int 			threadInitialized;
extern const ThreadOptions	threadDefaultOptions;
extern Thread			threadSelf;

#define tSelf			(0, threadSelf + 0)

#define threadName(t)		(0, (t)->option.name + 0)
#define threadSetContFunc(t,f)	{(t)->func = (f);}
#define threadSetContArg(t,a)	{(t)->option.arg = (a);}

extern void	threadInit (ThreadFunc init, void*   arg);
extern Thread	threadCreate (ThreadFunc func, const ThreadOptions opt);
extern void	threadStop (void);
extern void	threadSuspend (void);
extern void	threadSuspendWithContinuation (void);
extern void	threadWakeup (Thread t);
extern void	threadAsyncWakeup (Thread t);
extern void	threadYield (void);
extern size_t	threadFreeStack (void);

#endif /* __thread_h__ */
