/*
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: $
 *
 * HISTORY
 * $Log: $
 */
#ifndef __semaphore_h__
#define __semaphore_h__

#include "xk_queue.h"

typedef struct Semaphore {
    int			count;
    struct Queue	waitingQ;
} Semaphore;

extern void	semInit (Semaphore* s, unsigned initialVal);
extern void	semWait (Semaphore* s);
/*
 * semSignal does not constitute a scheduling point.  Calling thread
 * is guaranteed to resume execution immediately.
 */
extern void	semSignal (Semaphore* s);
/*
 * Let n=semaphoreCount(s).  Then n>=0 => can perform n semaphoreWait() before
 * blocking, or if n<0 => there are -n threads blocked on semaphore.
 */
extern int	semCount (Semaphore* s);
/*
 * semaphoreSignalAll is identical to:
 *	for (i = 0; i < -semaphoreCount(s); ++i) semaphoreSignal(s);
 */
extern void	semSignalAll (Semaphore* s);

#endif /* __semaphore_h__ */
