/*
 */
#ifndef __fifo_h__
#define __fifo_h__

/*
 * This module provides a FIFO queueing service for multiple producers
 * and a single consumer that operate concurrently.  Usually, "append"
 * and "remove" can be invoked concurrently without incurring any
 * synchronization overheads.  The only case where synchronization
 * overheads occur is when removing the last element in a queue.
 */

typedef struct FIFO *	FIFO;
typedef struct FIFOEl *	FIFOEl;

struct FIFO {
    FIFOEl	head;
    FIFOEl	tail;
};

struct FIFOEl {
    FIFOEl	next;
};

extern void	fifoInit (FIFO q);
extern void	fifoAppend (FIFO q, void *element);
extern void *	fifoRemove (FIFO q);

#endif /* __fifo_h__ */
