/* 
 * $RCSfile: xk_assert.h,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Log: xk_assert.h,v $
 * Revision 1.2  1996/01/31  16:23:54  slm
 * Updated copyright and version.
 *
 * Revision 1.1  1995/07/29  02:56:13  slm
 * Initial revision
 *
 * Revision 1.2.1.1  1994/10/28  17:33:21  hkaram
 * New branch
 *
 * Revision 1.2  1994/05/06  20:24:32  gordon
 * working Solaris version
 *
 * Revision 1.1  1994/04/07  03:45:27  ho
 * Initial revision
 *
 * Revision 1.10  1994/02/05  00:06:30  menze
 *   [ 1994/01/27          menze ]
 *   Renamed to xk_assert.h to avoid conflicts
 */

#ifndef xk_assert_h
#define xk_assert_h

#include <stdio.h>

#ifdef __STDC__

extern void abort(void);

#else

extern void abort();

#endif

#define PRINT(A,B,C) fprintf(stderr, (A), (B), (C))
#define assertMessage "Assertion failed: file %s, line %d\n"

# ifdef lint
   extern int assert__x_;
#  define xAssert(ex) (assert__x_ = (ex), assert__x_ = assert__x_ )
#  define _xAssert(ex)(assert__x_ = (ex), assert__x_ = assert__x_ )
# else
#  ifdef XK_DEBUG
#   define _xAssert(ex) ((ex) ? (void)1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
#   define xAssert(ex)  ((ex) ? (void)1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
#  else
#   define _xAssert(ex) {}
#   define xAssert(ex) {}
#  endif XK_DEBUG
# endif lint
#endif /* xk_assert_h */
