/*
 * rdate.c - client program for remote date service.
 */

#include	<stdio.h>
#include	"Date1_defs.h"		/* this file generated by xnscourier */

#include	<sys/types.h>
#include	<netns/ns.h>		/* definition of struct ns_addr */

main(argc, argv)
int	argc;
char	*argv[];
{
	CourierConnection	*conn;		/* RPC handle */
	char			*server;
	struct ns_addr		ns_addr(),	/* BSD library routine */
				servaddr;
	BinDateResults		binresult;	/* result from BinDate() */
	StrDateResults		strresult;	/* result from StrDate() */

	if (argc != 2) {
		fprintf(stderr, "usage: %s hostaddr\n", argv[0]);
		exit(1);
	}
	server = argv[1];
	servaddr = ns_addr(argv[1]);	/* convert to an ns_addr structure */

	/*
	 * Create the client "handle."
	 */

	if ( (conn = CourierOpen(&servaddr)) == NULL) {
		fprintf(stderr, "Can't open connection to %s\n", server);
		exit(2);
	}

	/*
	 * First call the remote procedure BinDate().
	 */

	binresult = BinDate(conn, NULL);
	printf("time on host %s = %ld\n", server, binresult.bindate);

	/*
	 * Now call the remote procedure StrDate().
	 */

	strresult = StrDate(conn, NULL, binresult.bindate);
	printf("time on host %s = %s", server, strresult.strdate);

	CourierClose(conn);		/* close the connection cleanly */
	exit(0);
}
